<?php
/*
class-scc-share-twitter-strategy.php

Description: This class is abstract class of a data crawler
Author: Daisuke Maruyama
Author URI: http://marubon.info/
License: GPL2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.txt
*/

/*
Copyright (C) 2014 - 2018 Daisuke Maruyama

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

class SCC_Share_Twitter_Strategy extends SCC_Crawl_Strategy {

	/**
	 * SNS base url (widgetoon.js & count.jsoon)
	 * @var string
	 */
	const DEF_BASE_URL_JSOON = 'http://jsoon.digitiminimi.com/twitter/count.json';

	/**
	 * SNS base url (OpenShareCount)
	 * @var string
	 */
	const DEF_BASE_URL_OPENSHARECOUNT = 'http://opensharecount.com/count.json';

	/**
	 * SNS base url (TwitCount)
	 * @var string
	 */
	const DEF_BASE_URL_TWITCOUNT = 'http://counts.twitcount.com/counts.php';

	/**
	 * SNS base url (NewShareCounts)
	 * @var string
	 */
	const DEF_BASE_URL_NEWSHARECOUNTS = 'http://public.newsharecounts.com/count.json';

	/**
	 * Class constarctor
	 * Hook onto all of the actions and filters needed by the plugin.
	 *
	 */
	protected function __construct() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		$this->http_method = 'GET';
	}

	/**
	 * Initialization
	 * @param  array  $options Option for this strategy
	 * @return null There is no return.
	 */
	public function initialize( $options = array() ) {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		if ( isset( $options['twitter_api'] ) ) {
			$this->twitter_api = $options['twitter_api'];
		}

	}

	/**
	 * Build header
	 * @return null no need to build header for Twitter share count retrieval.
	 */
	public function build_query_header() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		return null;
	}

	/**
	 * [build_query_body description]
	 * @return [type] [description]
	 */
	public function build_query_body() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		return null;
	}

	/**
	 * Build query URL
	 * @return string Query URL
	 */
	public function build_query_url() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		$base_url = self::DEF_BASE_URL_JSOON;

		if ( isset( $this->twitter_api ) && $this->twitter_api ) {
			if ( SNS_Count_Cache::OPT_SHARE_TWITTER_API_JSOON === $this->twitter_api ) {
				$base_url = self::DEF_BASE_URL_JSOON;
			} elseif ( SNS_Count_Cache::OPT_SHARE_TWITTER_API_OPENSHARECOUNT === $this->twitter_api ) {
				$base_url = self::DEF_BASE_URL_OPENSHARECOUNT;
			} elseif ( SNS_Count_Cache::OPT_SHARE_TWITTER_API_TWITCOUNT === $this->twitter_api ) {
				$base_url = self::DEF_BASE_URL_TWITCOUNT;
			} elseif ( SNS_Count_Cache::OPT_SHARE_TWITTER_API_NEWSHARECOUNTS === $this->twitter_api ) {
				$base_url = self::DEF_BASE_URL_NEWSHARECOUNTS;
			}
		}

		$url = $base_url . '?' . http_build_query( $this->query_parameters , '' , '&' );

		return $url;
	}

	/**
	 * Extract count
	 * @param string  $content Target content
	 * @return int SNS count
	 */
	public function extract_count( $content ) {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		$count = (int) -1;

		if ( isset( $content['data'] ) && empty( $content['error'] ) ) {
			$json = json_decode( $content['data'], true );

			if ( isset( $json['count'] ) && is_numeric( $json['count'] ) ) {
				$count = (int) $json['count'];
			} else {
				$count = (int) -1;
			}
		} else {
			$count = (int) -1;
		}

		return $count;
	}

	/**
	 * [set_parameter description]
	 * @param [type] $key   [description]
	 * @param [type] $value [description]
	 */
	public function set_parameter( $key, $value ) {
		if ( isset( $this->twitter_api ) && $this->twitter_api ) {
			if ( SNS_Count_Cache::OPT_SHARE_TWITTER_API_JSOON === $this->twitter_api ) {
				if ( 'url' === $key ) {
					if ( home_url( '/', 'http' ) === $value || home_url( '/', 'https' ) === $value ) {
						$this->query_parameters[ $key ] = '"' . $value . '"';
					} else {
						$this->query_parameters[ $key ] = $value;
					}
				}
			} elseif ( SNS_Count_Cache::OPT_SHARE_TWITTER_API_OPENSHARECOUNT === $this->twitter_api ) {
				if ( 'url' === $key ) {
					$this->query_parameters[ $key ] = $value;
				}
			} elseif ( SNS_Count_Cache::OPT_SHARE_TWITTER_API_TWITCOUNT === $this->twitter_api ) {
				if ( 'url' === $key ) {
					$this->query_parameters[ $key ] = $value;
				}
			} elseif ( SNS_Count_Cache::OPT_SHARE_TWITTER_API_NEWSHARECOUNTS === $this->twitter_api ) {
				if ( 'url' === $key ) {
					$this->query_parameters[ $key ] = $value;
				}
			}
		} else {
			if ( 'url' === $key ) {
				$this->query_parameters[ $key ] = $value;
			}
		}
	}

	/**
	 * Check if required paramters are included or not.
	 * @return boolean Check result
	 */
	public function check_configuration() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		if ( isset( $this->query_parameters['url'] ) && $this->query_parameters['url'] ) {
			return true;
		} else {
			return false;
		}
	}

}
