<?php
/*
class-scc-follow-onesignal-strategy.php

Description: This class is abstract class of a data crawler
Author: Daisuke Maruyama
Author URI: http://marubon.info/
License: GPL2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.txt
*/

/*
Copyright (C) 2014 - 2018 Daisuke Maruyama

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

class SCC_Follow_Onesignal_Strategy extends SCC_Crawl_Strategy {

	/**
	 * SNS base url
	 * @var string
	 */
	const DEF_BASE_URL = 'https://onesignal.com/api/v1/apps';

	/**
	 * Class constarctor
	 * Hook onto all of the actions and filters needed by the plugin.
	 *
	 */
	protected function __construct() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		$this->http_method = 'GET';
	}

	/**
	 * Initialization
	 * @param  array  $options [description]
	 * @return [type]          [description]
	 */
	public function initialize( $options = array() ) {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		$this->set_parameters( $options );
	}

	/**
	 * Build header
	 * @return [type] [description]
	 */
	public function build_query_header() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		$headers = array();

		$headers['Content-Type'] = 'application/json';
		$headers['Authorization'] = 'Basic ' . $this->parameters['user_auth_key'];

		return $headers;
	}

	/**
	 * [build_content description]
	 * @return [type] [description]
	 */
	public function build_query_body() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		return null;
	}

	/**
	 * Build query url
	 * @return [type] [description]
	 */
	public function build_query_url() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		$url = self::DEF_BASE_URL . '/' . $this->parameters['app_id'];

		return $url;
	}

	/**
	 * Extract count
	 * @param  [type] $content [description]
	 * @return [type]          [description]
	 */
	public function extract_count( $content ) {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		$count = (int) -1;

		if ( isset( $content['data'] ) && empty( $content['error'] ) ) {
			$json = json_decode( $content['data'], true );

			if ( isset( $json['players'] ) && is_numeric( $json['players'] ) ) {
				$count = (int) $json['players'];
			} else {
				$count = (int) -1;
			}
		} else {
			$count = (int) -1;
		}

		return $count;
	}

	/**
	 * [set_parameter description]
	 * @param [type] $key   [description]
	 * @param [type] $value [description]
	 */
	public function set_parameter( $key, $value ) {

		if ( 'app_id' === $key ) {
			$this->parameters[ $key ] = $value;
		} elseif ( 'user_auth_key' === $key ) {
			$this->parameters[ $key ] = $value;
		}

	}

	/**
	 * Check if required paramters are included or not.
	 * @return [type] [description]
	 */
	public function check_configuration() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		if ( isset( $this->parameters['app_id'] ) && $this->parameters['app_id'] &&
			isset( $this->parameters['user_auth_key'] ) && $this->parameters['user_auth_key']
		) {
			return true;
		} else {
			return false;
		}

	}

}
