<?php
/*
class-scc-crawl-strategy.php

Description: This class is abstract class of a data crawler
Author: Daisuke Maruyama
Author URI: http://marubon.info/
License: GPL2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.txt
*/

/*
Copyright (C) 2014 - 2018 Daisuke Maruyama

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

abstract class SCC_Crawl_Strategy {

	/**
	 * [protected description]
	 * @var [type]
	 */
	protected $url = '';

	/**
	 * [protected description]
	 * @var [type]
	 */
	protected $http_method = null;

	/**
	 * [protected description]
	 * @var [type]
	 */
	protected $parameters = array();

	/**
	 * [protected description]
	 * @var [type]
	 */
	protected $query_parameters = array();

	/**
	 * [private description]
	 * @var [type]
	 */
	private static $instance = array();

	/**
	 * Class constarctor
	 * Hook onto all of the actions and filters needed by the plugin.
	 *
	 */
	protected function __construct() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		//$this->get_object_id();
	}

	/**
	 * Get instance
	 * @return [type] [description]
	 */
	public static function get_instance() {
		$class_name = get_called_class();

		if ( ! isset( self::$instance[ $class_name ] ) ) {
			self::$instance[ $class_name ] = new $class_name();
		}

		return self::$instance[ $class_name ];
	}

	/**
	 * Return object ID
	 * @return [type] [description]
	 */
	public function get_object_id() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		$object_id = spl_object_hash( $this );

		SCC_Logger::log( '[' . __METHOD__ . '] object ID: ' . $object_id );

		return $object_id;
	}

	/**
	 * Inhibit clone
	 * @return [type] [description]
	 */
	final public function __clone() {
		 throw new Exception( 'Clone is not allowed against' . get_class( $this ) );
	}

	/**
	 * [initialize description]
	 * @param  array  $options [description]
	 * @return [type]          [description]
	 */
	abstract public function initialize( $options = array() );

	/**
	 * [get_url description]
	 * @return [type] [description]
	 */
	public function get_url() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		return $url;
	}

	/**
	 * [set_url description]
	 * @param [type] $url [description]
	 */
	public function set_url( $url ) {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		$this->url = $url;
	}

	/**
	 * [get_parameters description]
	 * @return [type] [description]
	 */
	public function get_parameters() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		return $this->parameters;
	}

	/**
	 * [get_parameter description]
	 * @param  [type] $key [description]
	 * @return [type]      [description]
	 */
	public function get_parameter( $key ) {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		return $this->parameters[ $key ];
	}

	/**
	 * [set_parameters description]
	 * @param array $parameters [description]
	 */
	public function set_parameters( $parameters = array() ) {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );

		foreach ( $parameters as $key => $value ) {
			$this->set_parameter( $key, $value );
		}
	}

	/**
	 * [set_parameter description]
	 * @param [type] $key   [description]
	 * @param [type] $value [description]
	 */
	public function set_parameter( $key, $value ) {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		$this->parameters[ $key ] = $value;
	}

	/**
	 * [get_http_method description]
	 * @return [type] [description]
	 */
	public function get_http_method() {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		return $this->http_method;
	}

	/**
	 * [set_http_method description]
	 * @param [type] $http_method [description]
	 */
	public function set_http_method( $http_method ) {
		SCC_Logger::log( '[' . __METHOD__ . '] (line=' . __LINE__ . ')' );
		$this->http_method = $http_method;
	}

	/**
	 * [build_query_url description]
	 * @return [type] [description]
	 */
	abstract public function build_query_url();

	/**
	 * [extract_count description]
	 * @param  [type] $content [description]
	 * @return [type]          [description]
	 */
	abstract public function extract_count( $content );

	/**
	 * [build_query_header description]
	 * @return [type] [description]
	 */
	abstract public function build_query_header();

	/**
	 * [build_query_body description]
	 * @return [type] [description]
	 */
	abstract public function build_query_body();

	/**
	 * [check_configuration description]
	 * @return [type] [description]
	 */
	abstract public function check_configuration();

}
