<?php
class Mcrypt {

	private $td;
	private $iv_size;
	private $algorithm;
	private $mode;
	private $init = false;

	function __construct( $algorithm = 'blowfish', $mode = 'ecb' ) {
		Common_Util::log( '[' . __METHOD__ . '] (line='. __LINE__ . ')' );
		$this->algorithm = $algorithm;
		$this->mode = $mode;
		$this->td = mcrypt_module_open( $this->algorithm, '', $this->mode, '' );
		$this->iv_size  = mcrypt_enc_get_iv_size( $this->td );
	}

	function __destruct(){
		if ( $this->init ) mcrypt_generic_deinit( $this->td );
		mcrypt_module_close( $this->td );
	}

	private function init( $pass, $iv = null ) {
		Common_Util::log( '[' . __METHOD__ . '] (line='. __LINE__ . ')' );
		if ( is_null( $iv ) ) {
			$iv = mcrypt_create_iv( $this->iv_size, MCRYPT_DEV_RANDOM );
		} else {
			$iv = base64_decode( $iv );
		}

		if ( $this->iv_size !== strlen( $iv ) ) {
			throw new Exception( 'Incorrect IV size.' );
		}

		$key = substr( md5( $pass ), 0, mcrypt_enc_get_key_size( $this->td ) );
		mcrypt_generic_init( $this->td, $key, $iv );
		$this->init = true;
	}

	public function encrypt( $str, $pass, $iv = null ) {
		Common_Util::log( '[' . __METHOD__ . '] (line='. __LINE__ . ')' );
		$iv = $this->init( $pass, $iv );
		Common_Util::log( '[' . __METHOD__ . '] iv' );
		$encrypted = mcrypt_generic( $this->td, $str );
		return base64_encode( $encrypted );
	}

	public function decrypt( $str, $pass, $iv = null ) {
		Common_Util::log( '[' . __METHOD__ . '] (line='. __LINE__ . ')' );
		$iv = $this->init( $pass, $iv );
		Common_Util::log( '[' . __METHOD__ . '] iv' );
		$str = base64_decode( $str );
		$decrypted = mdecrypt_generic( $this->td, $str );
		Common_Util::log( '[' . __METHOD__ . '] decrypted: ' . $decrypted );
		return $decrypted;
	}

	public function create_iv() {
		Common_Util::log( '[' . __METHOD__ . '] (line='. __LINE__ . ')' );
		$iv = mcrypt_create_iv( $this->iv_size, MCRYPT_DEV_RANDOM );
		return base64_encode( $iv );
	}
}

?>
